<?php if (!defined('ROOTPATH')) exit('No direct script access allowed'); ?>
<?php
$burndown->tests->color = '#1B55D3';
$burndown->forecasts->color = '#E3505B';
$burndown->burndown->color = '#B0B0B0';
$PARENT_Y_AXIS = 2;
?>

<?php
$burndown->burndown->label = lang('burndown_chart_series_burndown');
$burndown->burndown->y_axis = 1;
$burndown->tests->label = lang('burndown_chart_series_tests');
$burndown->tests->y_axis = 0;
$burndown->forecasts->label = lang('burndown_chart_series_forecasts');
$burndown->forecasts->y_axis = 1;

$lines = array();
if ($progress->projected_end_date) {
    $lines = array(
        $burndown->tests,
        $burndown->burndown,
        $burndown->forecasts
    );
} else {
    if ($progress->forecast !== null) {
        $lines = array(
            $burndown->tests,
            $burndown->forecasts
        );
    } else {
        $lines = array($burndown->tests);
    }
}
?>

<?php if (!function_exists('_y_axis_get_ticks')) : ?>
    <?php
    function _y_axis_get_ticks($values, $steps)
    {
        $max = max($values);

        if (($max % $steps) == 0) {
            $tick_interval = (int) ($max / $steps);
        } else {
            $tick_interval = round($max / $steps);
        }

        $ticks = array();
        if ($max <= $steps) {
            for ($i = 0; $i <= $max; $i++) {
                $ticks[] = $i;
            }
        } else {
            for ($i = 0; $i <= $steps; $i++) {
                if ($i != $steps) {
                    $tick = $tick_interval * $i;
                } else {
                    $tick = $max;
                }

                $ticks[] = $tick;
            }
        }

        return $ticks;
    }
    ?>
<?php endif ?>

<?php
$y0_ticks = _y_axis_get_ticks($burndown->tests->values, 8);
$y1_ticks = _y_axis_get_ticks($burndown->forecasts->values, 8);

$label_items = tests::getFormattedLabelsForFC($burndown->labels);
$line_items = [];
$start_burndown = 0;
$end_burndown = 0;
foreach ($lines ?? [] as $line_index => $line) {
    $line_name = h($line->label);
    if ($line_index === 1) {
        if (is_array($line->values)) {
            $line_values = $line->values;
            $start_burndown = array_shift($line_values);
            $end_burndown = array_pop($line_values);
        }
        continue;
    }
    $line_values = [];
    foreach ($line->values ?? [] as $line_value) {
        $line_values[] = [
            'value' => $line_value
        ];
    }
    $line_item_param = [
        'seriesname' => $line_name,
        'renderAs' => 'line',
        'color' => $line->color,
        'data' => $line_values
    ];
    if ($line_index === $PARENT_Y_AXIS) {
        $line_item_param['parentYAxis'] = 'S';
    }
    $line_items[] = $line_item_param;
}

if (!empty($report->id)) {
    $dataSource = [
        'type' => 'mscombidy2d',
        'creditLabel' => false,
        'height' => 230,
        'width' => 650,
        'dataSource' => [
            'chart' => [
                'showLegend' => 0,
                'theme' => 'fusion',
                'drawAnchors' => 0,
                'baseFont' => 'Barlow',
                'baseFontSize' => '14',
                'baseFontColor' => '#4D4D4D',
                'chartBottomMargin' => 0
            ],
            'categories' => [
                ['category' => $label_items]
            ],
            'dataset' => $line_items,
            'trendlines' => [
                [
                    'line' => [
                        [
                            'parentYAxis' => 'S',
                            'startvalue' => $start_burndown,
                            'endValue' => $end_burndown,
                            'color' => '#D0D0D0',
                            'thickness' => 2,
                            'alpha' => 100
                        ]
                    ]
                ]
            ]
        ]
    ];

    $reportObj = $GI->load->model('report_helper');
    $encodedImage = $reportObj->jsonToImage(
        json_encode($dataSource),
        $report->path
    );
}
?>
<div class="chartContainer" style="height: 230px; width: 925px; margin-bottom: 1em">
    <div class="chartColumn" style="margin-right: 50px">
        <div id="burndownChart" style="height: 230px; width: 650px; overflow: hidden">
            <?php echo  $encodedImage ?? '' ?>
        </div>
    </div>
    <div class="chartColumn" style="width: 225px">
        <?php
        $temp['progress'] = $progress;
        $GI->load->view('report_plugins/charts/burndown/legend', $temp);
        ?>
    </div>
    <div style="clear: both"></div>
</div>

<script type="text/javascript">
    var chart_burndown;
    $(function() {
        $(document).ready(function() {
            chart_burndown = new FusionCharts({
                type: 'mscombidy2d',
                renderAt: 'burndownChart',
                width: '100%',
                height: '100%',
                dataSource: {
                    chart: {
                        showLegend: '0',
                        theme: "fusion",
                        drawAnchors: "0",
                        baseFont: 'Barlow',
                        baseFontSize: '14',
                        baseFontColor: '#4D4D4D',
                        chartBottomMargin: '0'
                    },
                    categories: [{
                        category: <?php echo  json::encode($label_items) ?>
                    }],
                    dataset: <?php echo  json::encode($line_items) ?>,
                    trendlines: [{
                        line: [{
                            parentYAxis: "S",
                            startvalue: <?php echo  $start_burndown ?>,
                            endValue: <?php echo  $end_burndown ?>,
                            color: '#D0D0D0',
                            thickness: 2,
                            alpha: 100
                        }]
                    }]
                }
            }).render();
        });
    });
</script>