<?php if (!defined('ROOTPATH')) exit('No direct script access allowed'); ?>
<?php $statuses = $GI->cache->get_objects('status') ?>

<?php
$stats = $milestone;
?>

<?php $statuses_to_include = array() ?>
<?php foreach ($statuses as $status) : ?>
    <?php $prop_count = $status->system_name . '_count' ?>
    <?php if (!$status->is_untested && ($status->is_active || $stats->$prop_count > 0)) : ?>
        <?php $statuses_to_include[] = $status ?>
    <?php endif ?>
<?php endforeach ?>

<?php $statuses_to_include_count = count($statuses_to_include) ?>
<?php if ($statuses_to_include_count > 4) : ?>
    <?php $legend_columns = 2 ?>
<?php else : ?>
    <?php $legend_columns = 1 ?>
<?php endif ?>

<?php $chart_id = isset($chart_id) ? $chart_id : 'statusChart' ?>
<?php
$status_items = [];
if ($stats->total_count === 0) {
    $status = $GI->cache->get_object('status', TP_TEST_STATUS_UNTESTED);
    if (!empty($status)) {
        $status_items[] = [
            'label' => h($status->label),
            'color' => color::format($status->color_medium),
            'value' => 1
        ];
    }
} else {
    foreach ($statuses as $status) {
        $prop_count = $status->system_name . '_count';
        if ($status->is_active || $stats->$prop_count > 0) {
            $status_items[] = [
                'label' => h($status->label),
                'color' => color::format($status->color_medium),
                'value' => $stats->$prop_count
            ];
        }
    }
}

if (!empty($report->id)) {
    $dataSource = [
        'type' => 'pie2d',
        'creditLabel' => false,
        'width' => 300,
        'height' => 300,
        'dataSource' => [
            'chart' => [
                'theme' => 'fusion',
                'baseFont' => 'Barlow',
                'baseFontSize' => '14',
                'baseFontColor' => '#4D4D4D',
                'showLabels' => false,
                'showLegend' => false,
                'showValues' => false,
                'enableSlicing' => false
            ],
            'data' => $status_items
        ]
    ];

    $reportObj = $GI->load->model('report_helper');
    $encodedImage = $reportObj->jsonToImage(
        json_encode($dataSource),
        $report->path
    );
}
?>
<div class="chart-wrapper-outter">
    <div class="chart-wrapper-inner">
        <div class="chartContainer" style="height: 400px; width: fit-content; margin-bottom: 1em; display: block;">
            <div class="chartColumn">
                <div id="<?php echo  $chart_id ?>" style="height: 400px; width: 450px">
                    <?php echo  $encodedImage ?? '' ?>
                </div>
            </div>
            <?php
            $temp = array();
            $temp['stats'] = $stats;
            $temp['statuses'] = $statuses_to_include;
            ?>
            <div class="chartColumn" style="width: <?php echo  $legend_columns == 2 ? 550 : 350 ?>px; float: none!important;">
                <div style="chartColumnInner">
                    <?php $GI->load->view('report_plugins/charts/status/legend', $temp); ?>
                    <?php $GI->load->view('report_plugins/charts/status/percent', $temp); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    var chart_status;

    $(function() {
        $(document).ready(function() {
            chart_status = new FusionCharts({
                type: 'pie2d',
                renderAt: '<?php echo  $chart_id ?>',
                width: '100%',
                height: '100%',
                dataSource: {
                    chart: {
                        theme: 'fusion',
                        baseFont: 'Barlow',
                        baseFontSize: '14',
                        baseFontColor: '#4D4D4D',
                        showLabels: false,
                        showLegend: false,
                        showValues: false,
                        plotToolText: '<strong>$label</strong> <br />$value ($percentValue)',
                        animation: false,
                        enableSlicing: false
                    },
                    data: <?php echo  json::encode($status_items) ?>
                }
            }).render();
        });
    });
</script>