<?php if (!defined('ROOTPATH')) exit('No direct script access allowed'); ?>
<?php
$first_day = $tests_result['first_day']->format('Y/m/d H:i:s');
$last_day = $tests_result['last_day']->format('Y/m/d H:i:s');;
$total_num_test = $tests_result['total_num_test'];
$total_num_defect = $tests_result['total_num_defect'];
$total_elasped_day = $tests_result['total_elasped_day'];
$graph1_data = $tests_result['graph1_data'];
$graph2_data = $tests_result['graph2_data'];
$graph3_data = $tests_result['graph3_data'];
$final_statuses_name = implode(", ", $tests_result['final_statuses_name']);
?>

<div class="statsContainer">
	<div class="statsIcon">
		<img src="%RESOURCE%:images/report-assets/stats.svg" height="32" width="32" alt="" />
	</div>
	<div class="statsContent">
		<table class="grid">
			<colgroup>
				<col style="width: 200px">
				</col>
				<col style="width: 400px">
				</col>
			</colgroup>
			<tr class="header noBorder" style="background: #E0E0E0">
				<th><?php echo  lang("reports_ms_rgc_grid_type") ?></th>
				<th><?php echo  lang("reports_ms_rgc_grid_value") ?></th>
			</tr>
			<tr class="noBorder">
				<td><?php echo  lang("reports_ms_rgc_grid_first_day") ?></td>
				<td><?php echo $first_day ?></td>
			</tr>
			<tr class="noBorder">
				<td><?php echo  lang("reports_ms_rgc_grid_last_day") ?></td>
				<td><?php echo $last_day ?></td>
			</tr>
			<tr class="noBorder">
				<td><?php echo  lang("reports_ms_rgc_grid_total_num_defect") ?></td>
				<td><?php echo $total_num_defect ?></td>
			</tr>
			<tr class="noBorder">
				<td><?php echo  lang("reports_ms_rgc_grid_total_num_test") ?></td>
				<td><?php echo $total_num_test ?></td>
			</tr>
			<tr class="noBorder">
				<td><?php echo  lang("reports_ms_rgc_grid_total_elasped_day") ?></td>
				<td><?php echo $total_elasped_day ?></td>
			</tr>
			<tr class="noBorder">
				<td><?php echo  lang("reports_ms_rgc_grid_statuses") ?></td>
				<td><?php echo $final_statuses_name ?></td>
			</tr>
		</table>
	</div>
	<div style="clear: both"></div>
</div>

<div style="width:950px; margin:10px;"><canvas id="chart1"></canvas></div>
<div style="width:950px; margin:10px;"><canvas id="chart2"></canvas></div>
<div style="width:950px; margin:10px;"><canvas id="chart3"></canvas></div>

<?php
echo '<script>';
echo 'var graph1Data = ' . json_encode($graph1_data) . ';';
echo 'var graph2Data = ' . json_encode($graph2_data) . ';';
echo 'var graph3Data = ' . json_encode($graph3_data) . ';';
echo 'var label_number_of_defects  = "' . lang("reports_ms_rgc_label_num_defect") . '";';
echo 'var graph_title_elasped_day  = "' . lang("reports_ms_rgc_label_graph_title_elasped_day") . '";';
echo 'var graph_title_elasped_time = "' . lang("reports_ms_rgc_label_graph_title_elasped_time") . '";';
echo 'var graph_title_test         = "' . lang("reports_ms_rgc_label_graph_title_test") . '";';

echo '
	var ctx1 = document.getElementById("chart1").getContext("2d");
	const chart1 = new Chart(ctx1, {
		type: "line",
		data: {
			labels: graph1Data.map(data => data.label),
			datasets: [{
				label: label_number_of_defects,
				spanGaps: true,
				data: graph1Data.map(data => data.value),
				fill: false,
				cubicInterpolationMode: "monotone",
				tension: 0.4
			}]
		},
		options: {
			responsive: true,
	    	elements: {
      			point:{
      				radius: 0
      			}
			},
			plugins: {
				title: {
					display: true,
					text: graph_title_elasped_time
				},
			},
			interaction: {
				intersect: false,
			},
			scales: {
				x: {
					display: true,
					title: {
						display: true
					}
				},
				y: {
					display: true,
					title: {
						display: true,
						text: label_number_of_defects
					}
				}
			}
		}
	});

	var ctx2 = document.getElementById("chart2").getContext("2d");
	const chart2 = new Chart(ctx2, {
		type: "line",
		data: {
			labels: graph2Data.map(data => data.label),
			datasets: [{
				label: label_number_of_defects,
				spanGaps: true,
				data: graph2Data.map(data => data.value),
				fill: false,
				cubicInterpolationMode: "monotone",
				tension: 0.4
			}]
		},
		options: {
			responsive: true,
			plugins: {
				title: {
					display: true,
					text: graph_title_elasped_day
				},
			},
			interaction: {
				intersect: false,
			},
			scales: {
				x: {
					display: true,
					title: {
						display: true
					}
				},
				y: {
					display: true,
					title: {
						display: true,
						text: label_number_of_defects
					}
				}
			}
		},
	});

	var ctx3 = document.getElementById("chart3").getContext("2d");
	const chart3 = new Chart(ctx3, {
		type: "line",
		data: {
			labels: graph3Data.map(data => data.label),
			datasets: [{
				label: label_number_of_defects,
				data: graph3Data.map(data => data.value),
				fill: false,
				cubicInterpolationMode: "monotone",
				tension: 0.4
			}]
		},
		options: {
			responsive: true,
	    	elements: {
      			point:{
      				radius: 0
      			}
			},
			plugins: {
				title: {
					display: true,
					text: graph_title_test
				},
			},
			interaction: {
				intersect: false,
			},
			scales: {
				x: {
					display: true,
					title: {
						display: true
					}
				},
				y: {
					display: true,
					title: {
						display: true,
						text: label_number_of_defects
					}
				}
			}
		},
	});
	';
echo '</script>';
?>