name: Hide status in a specific project
description:
author:
version: 1.0
includes: ^runs/view
excludes:

js:
// 定数定義

// ステータスを非表示にするプロジェクトのIDリスト
const targetProjectIds = [1, 4 /* , 追加ID */];

// 非表示にするステータス名のリスト
const deleteStatus = new Set(["OK", "NG"]); 

// プロジェクトID取得
const projectId = uiscripts?.context?.project?.id || null;

// 指定のテキストに該当する要素を削除する共通関数
function removeByStatusText(elements) {
    elements.forEach(el => {
        const text = el.textContent?.trim();
        if (deleteStatus.has(text)) {
            el.remove();
        }
    });
}

// ステータスミニのli削除（隣接テキストを取る処理）
function removeStatusMiniItems() {
    $(".status-mini").each(function () {
        let sibling = this.nextSibling;
        while (sibling && sibling.nodeType !== Node.TEXT_NODE && sibling.nodeType !== Node.ELEMENT_NODE) {
            sibling = sibling.nextSibling;
        }

        let text = "";
        if (sibling) {
            if (sibling.nodeType === Node.TEXT_NODE) {
                text = sibling.textContent.trim();
            } else if (sibling.nodeType === Node.ELEMENT_NODE) {
                text = sibling.innerText.trim();
            }
        }

        if (deleteStatus.has(text)) {
            const li = $(this).closest("li");
            if (li.length) li.remove();
        }
    });
}

// select要素内のOK/NG option削除
function removeOkOptionFromSelect(selectElement) {
    const options = selectElement.options;
    for (let i = options.length - 1; i >= 0; i--) {
        if (deleteStatus.has(options[i].text)) {
            selectElement.remove(i);
        }
    }
}

// クラス名で指定のselectすべてに適用
function removeOkFromAllSelects() {
    document.querySelectorAll("select.form-control.form-select")
        .forEach(removeOkOptionFromSelect);
}

// MutationObserverの共通セットアップ（select要素用）
function observeSelectAdditions() {
    const observer = new MutationObserver(mutations => {
        mutations.forEach(mutation => {
            mutation.addedNodes.forEach(node => {
                if (node.nodeType !== Node.ELEMENT_NODE) return;

                if (node.matches && node.matches("select.form-control.form-select")) {
                    removeOkOptionFromSelect(node);
                }
                
                const selects = node.querySelectorAll?.("select.form-control.form-select");
                if (selects) selects.forEach(removeOkOptionFromSelect);
            });
        });
    });

    observer.observe(document.body, { childList: true, subtree: true });
    return observer;
}

// MutationObserverの共通セットアップ（.active-result用）
function observeActiveResultAdditions() {
    const observer = new MutationObserver(mutations => {
        mutations.forEach(mutation => {
            mutation.addedNodes.forEach(node => {
                if (node.nodeType !== Node.ELEMENT_NODE) return;

                if (node.classList.contains('active-result')) {
                    const text = node.textContent.trim();
                    if (deleteStatus.has(text)) {
                        node.remove();
                        return; // 削除済みのため処理終了
                    }
                }

                // 子孫の.active-resultも対象
                const nestedLis = node.querySelectorAll('.active-result');
                removeByStatusText(nestedLis);
            });
        });
    });

    observer.observe(document.body, { childList: true, subtree: true });
    return observer;
}

// DOM Ready処理開始
$(document).ready(function () {
    if (!projectId || !targetProjectIds.includes(projectId)) {
        return; // 対象外のプロジェクトIDの場合は処理しない
    }

    // ステータスミニ要素の削除
    removeStatusMiniItems();

    // select要素内の削除処理と監視
    removeOkFromAllSelects();
    observeSelectAdditions();

    // .active-result要素の削除処理と監視
    removeByStatusText(document.querySelectorAll('.active-result'));
    observeActiveResultAdditions();
});