"""
マイルストーンを'完了'します。
マイルストーンに含まれるテストラン/テスト計画を'クローズ'します。
指定したマイルストーンが親マイルストーンの場合、子マイルストーンを'完了'し、そのテストラン/テスト計画を'クローズ'します。

使い方：
１．TestRail の [管理] > [サイト設定] > [API] タブで 'API の有効化' チェックボックスを有効化してください。
２．ログイン情報をご利用環境に合わせて変更してください。(24~26行目)
３．実行時引数を2つ指定してください。
　　・第一引数：プロジェクトID
　　・第二引数：マイルストーンID
    実行例：　python.exe runautoclose.py 4 7
    ↑プロジェクトID が 4 で マイルストーンID が 7 のマイルストーンに関連するテストラン、テスト計画をクローズします。


TestRail version 7.5.3, 8.0.1.1029 以降で利用可能。
"""

import sys
from testrail import *

# 実行時引数の配列
# 第一引数：プロジェクトID
# 第二引数：マイルストーンID
args = sys.argv

# TestRail ログイン情報
client = APIClient('http://localhost:8000/')
client.user = 'taro@techmatrix.co.jp'
client.password = 'password'

# マイルストーン情報を取得
dict_infomilestone = client.send_get('get_milestone/' + args[2])

# 子マイルストーン情報を取得
list_child = dict_infomilestone.get('milestones')

# 親、子マイルストーンのIDをリスト化
mile_list_id = [d.get('id') for d in list_child]
mile_list_id.append(int(args[2]))

# マイルストーン数分繰り返す
for i, mile_id in enumerate(mile_list_id):
    # マイルストーン情報を取得
    dict_milestone = client.send_get('get_milestone/' + str(mile_id))

    # マイルストーンがオープン中だったらクローズする
    if dict_milestone.get('is_completed') is not True:
        # マイルストーンをクローズ
        dict_closedmilestone = client.send_post(
            'update_milestone/' + str(mile_id),
            {"is_completed": True}
            )

    # マイルストーンのテストランリストを取得
    testruns_dict = client.send_get('get_runs/' + args[1] + '&milestone_id=' + str(mile_id)).get('runs')

    # テストランのIDをリスト化
    run_list_id = [d.get('id') for d in testruns_dict]

    # テストラン数分繰り返す
    for i, run_id in enumerate(run_list_id):
        # テストラン情報を取得
        run = client.send_get('get_run/' + str(run_id))

        # テストランがクローズされていなければ、クローズ
        if run.get('is_completed') is not True:
            dict_closedrun = client.send_post(
                'close_run/' + str(run_id), {}
            )

    # マイルストーンのテスト計画リストを取得
    testplans_dict = client.send_get('get_plans/' + args[1] + '&milestone_id=' + str(mile_id)).get('plans')

    # テスト計画のIDをリスト化
    plan_list_id = [d.get('id') for d in testplans_dict]

    # テスト計画数分繰り返す
    for i, plan_id in enumerate(plan_list_id):
        # テスト計画情報を取得
        plan = client.send_get('get_plan/' + str(plan_id))

        # テスト計画がクローズされていなければ、クローズ
        if plan.get('is_completed') is not True:
            dict_closedplan = client.send_post(
                'close_plan/' + str(plan_id), {}
            )
