import requests
import re
from urllib.parse import unquote
from bs4 import BeautifulSoup

class WebClient:

    def __init__(self, base_url, user, password):
        self.user = user
        self.password = password
        if not base_url.endswith('/'):
            base_url += '/'
        self.__base_url = base_url
        self.__auth_url = base_url + 'index.php?/auth/login'

    def get_attachement(self, attachment_id):
        # セッションを作成
        self.__session = requests.Session()

        # ログインのPOSTデータ
        login_data = {
            "name": self.user,
            "password": self.password,
        }

        # ログイン実行
        login_response = self.__session.post(self.__auth_url, data=login_data)
        if login_response.status_code > 201:
            try:
                error = login_response.json()
            except:
                error = str(login_response.content)
            raise WebError('TestRail Web(login) returned HTTP %s (%s)' % (login_response.status_code, error))

        # 添付ファイル取得
        attachment_url = self.__base_url + 'index.php?/attachments/get/' + str(attachment_id)
        response = self.__session.get(attachment_url)
        if response.status_code > 201:
            try:
                error = response.json()
            except:
                error = str(response.content)
            raise WebError('TestRail Web returned HTTP %s (%s)' % (response.status_code, error))

        content_disposition = response.headers.get('Content-Disposition', '')

        # ファイル名のURLエンコード部分を取得
        filename_match = re.search(r"filename\*=(UTF-8'')?(.+)", content_disposition)

        # ファイル名
        filename = ""
        if filename_match:
            encoded_filename = filename_match.group(2)
            filename = unquote(encoded_filename)

        return filename,response.content

class WebError(Exception):
    pass
